/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.designer;

import filenet.vw.apps.designer.VWDesignerCoreData;
import filenet.vw.apps.designer.resources.VWResource;
import filenet.vw.base.CEObjectInfo;
import filenet.vw.base.SdfFileInfo;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.dialog.VWDialogButtons;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.event.IVWDialogButtonsActionListener;
import filenet.vw.toolkit.utils.event.VWDialogButtonsActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class VWCaseTypeSelectionDialog
extends VWModalDialog
implements IVWDialogButtonsActionListener {
    private static final Dimension DIM_DEFAULT_SIZE = new Dimension(400, 175);
    private JList m_ceObjInfoList = null;

    public VWCaseTypeSelectionDialog(VWDesignerCoreData designerCoreData, SdfFileInfo sdfFileInfo) {
        super(designerCoreData.getParentFrame());
        try {
            this.getContentPane().setLayout(new BorderLayout());
            this.setTitle(VWResource.s_caseTypeSelectionDialogTitle);
            this.setSize(DIM_DEFAULT_SIZE);
            JPanel displayPanel = this.getDisplayPanel(sdfFileInfo);
            if (displayPanel != null) {
                this.getContentPane().add((Component)displayPanel, "Center");
            }
            VWDialogButtons dialogButtons = new VWDialogButtons(35);
            dialogButtons.addDialogButtonsActionListener(this);
            this.getContentPane().add((Component)dialogButtons, "Last");
            if (this.m_ceObjInfoList.getModel().getSize() > 0) {
                this.m_ceObjInfoList.setSelectedIndex(0);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public CEObjectInfo getSelectedCEObject() {
        if (this.m_ceObjInfoList != null) {
            return (CEObjectInfo)this.m_ceObjInfoList.getSelectedValue();
        }
        return null;
    }

    public static void testDialog(SdfFileInfo sdfFileInfo) {
        VWSessionInfo sessionInfo = new VWSessionInfo(null, null);
        VWDesignerCoreData coreData = new VWDesignerCoreData(sessionInfo);
        VWCaseTypeSelectionDialog dlg = new VWCaseTypeSelectionDialog(coreData, sdfFileInfo);
        dlg.setVisible(true);
    }

    public void dialogButtonsActionPerformed(VWDialogButtonsActionEvent event) {
        switch (event.getID()) {
            case 1: {
                this.m_nExitStatus = 0;
                this.setVisible(false);
                break;
            }
            case 2: {
                this.m_nExitStatus = 1;
                this.setVisible(false);
                break;
            }
            case 32: {
                VWHelp.displayPage(VWHelp.Help_Process_Designer + "bpfdh200.htm");
            }
        }
    }

    private JPanel getDisplayPanel(SdfFileInfo sdfFileInfo) {
        try {
            JPanel displayPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(5, 5, 5, 15);
            displayPanel.add((Component)new JLabel(VWResource.s_solutionName), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            gbCons.gridwidth = 0;
            displayPanel.add((Component)new JLabel(sdfFileInfo.getSolutionName()), gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            VWToolbarBorder toolbarBorder = new VWToolbarBorder(VWResource.s_selectACaseType);
            JPanel clientPanel = toolbarBorder.getClientPanel();
            clientPanel.setLayout(new BorderLayout());
            CEObjectInfo[] caseObjects = sdfFileInfo.getCaseObjects();
            DefaultListModel<CEObjectInfo> listModel = new DefaultListModel<CEObjectInfo>();
            for (int i = 0; i < caseObjects.length; ++i) {
                listModel.addElement(caseObjects[i]);
            }
            if (sdfFileInfo.getGlobalProcessCollectionObjectInfo() != null) {
                listModel.addElement(sdfFileInfo.getGlobalProcessCollectionObjectInfo());
            }
            this.m_ceObjInfoList = new JList(listModel);
            this.m_ceObjInfoList.setSelectionMode(0);
            clientPanel.add((Component)new JScrollPane(this.m_ceObjInfoList), "Center");
            displayPanel.add((Component)toolbarBorder, gbCons);
            return displayPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }
}

